/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.pa;

import filenet.vw.apps.taskman.pa.PADataFieldWizard;
import filenet.vw.apps.taskman.pa.resources.VWResource;
import filenet.vw.apps.taskman.toolkit.dialog.IVWTaskWizardPanel;
import filenet.vw.base.VWString;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class PAReportingConfigurationPanel
extends JPanel
implements IVWTaskWizardPanel {
    PADataFieldWizard m_wizard = null;
    JRadioButton m_factTablesOnlyRadio = null;
    JRadioButton m_cubesAndFactTablesRadio = null;
    int m_fieldType = -1;

    public PAReportingConfigurationPanel(PADataFieldWizard wizard) {
        this.m_wizard = wizard;
        this.initLayout();
    }

    public boolean isMeasure() {
        return this.m_cubesAndFactTablesRadio.isSelected();
    }

    public void performValidation() throws Exception {
    }

    public String getInstructions() {
        return new VWString("vw.apps.taskman.pa.PAReportingConfigurationPanel.VWResource.SelectWhereDataFieldShouldBeExposed", "Select the data structure where you want the data field values exposed. The structure that you choose determines whether the data values are available for OLAP cube reports.").toString();
    }

    public String getHelpPath() {
        return VWHelp.Help_Process_TaskManager + "pa_data_fields.htm";
    }

    public void refresh() {
    }

    private void initLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 1;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.getTypePanel(), c);
    }

    private JPanel getTypePanel() {
        VWToolbarBorder borderPanel = new VWToolbarBorder(VWResource.ReportingType, 0);
        JPanel panel = borderPanel.getClientPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 1;
        this.m_cubesAndFactTablesRadio = new JRadioButton(VWResource.CubesAndFactTablesReporting, false);
        this.m_cubesAndFactTablesRadio.setBorder(null);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(20, 20, 0, 10);
        panel.add((Component)this.m_cubesAndFactTablesRadio, c);
        this.m_factTablesOnlyRadio = new JRadioButton(VWResource.FactTablesOnlyReporting, true);
        this.m_factTablesOnlyRadio.setBorder(null);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 20, 0, 10);
        panel.add((Component)this.m_factTablesOnlyRadio, c);
        ++c.gridy;
        c.gridx = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.weightx = 1.0;
        c.weighty = 1.0;
        panel.add(Box.createHorizontalStrut(0), c);
        ButtonGroup grp = new ButtonGroup();
        grp.add(this.m_factTablesOnlyRadio);
        grp.add(this.m_cubesAndFactTablesRadio);
        if (!this.m_wizard.isNewDataField()) {
            boolean exposeToFactTablesOnly = (this.m_wizard.getDataFieldNode().getCubeOptions() & 0x40) != 0;
            this.m_factTablesOnlyRadio.setSelected(exposeToFactTablesOnly);
            this.m_cubesAndFactTablesRadio.setSelected(!exposeToFactTablesOnly);
        } else {
            this.m_cubesAndFactTablesRadio.setSelected(true);
        }
        return borderPanel;
    }

    public boolean isExposedToFactTablesOnly() {
        return this.m_factTablesOnlyRadio.isSelected();
    }

    public boolean skipThisPanel() {
        return false;
    }
}

